<!-- Main Content -->

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('customers', 'Customers') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('customers', 'Customers') ?></div>
            </div>
        </div>
        <section>
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/list-user") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                <thead>
                                    <tr>
                                        <th data-field="id" class="text-center" data-visible="false" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                        <th data-field="username" class="text-center" data-sortable="true"><?= labels('user_name', 'User Name') ?></th>
                                        <th data-field="image" class="text-center"><?= labels('image', 'Image') ?></th>
                                        <th data-field="phone" class="text-center" ><?= labels('mobile', 'Mobile') ?></th>
                                        <th data-field="active" class="text-center" data-sortable="true"><?= labels('user_status', 'User Status') ?></th>
                                        <th data-field="operations" class="text-center" data-events="user_events"><?= labels('operations', 'Operations') ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>

    <!-- To deactivate given selected user -->
    <div class="modal fade" id="deactivate_user_modal" tabindex="-1" role="dialog" aria-labelledby="deactivate_user_modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?= labels('deactivate_user', 'Deactivate user') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?= base_url('admin/users/deactivate') ?>" method="post" id="deactivate_user_form">
                        <input type="hidden" name="user_id" id="user_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', 'Close') ?></button>
                    <button type="submit" class="btn btn-primary" id="deactive_btn"><?= labels('deactivate_user', 'Deactivate user') ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- To activate given selected user -->
    <div class="modal fade" id="activate_user_modal" tabindex="-1" role="dialog" aria-labelledby="activate_user_modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?= labels('activate_user', 'Activate User') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?= base_url('admin/users/activate') ?>" method="post" id="activate_user_form">
                        <input type="hidden" name="user_id" id="user_id_active">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', 'Close') ?></button>
                    <button type="submit" class="btn btn-primary" id="activate_btn"><?= labels('activate_user', 'Activate User') ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>